unit Text_U;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Resources;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Button1: System.Windows.Forms.Button;
    Button2: System.Windows.Forms.Button;
    Button3: System.Windows.Forms.Button;
    Button4: System.Windows.Forms.Button;
    Button5: System.Windows.Forms.Button;
    Button6: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TWinForm_Paint(sender: System.Object; e: System.Windows.Forms.PaintEventArgs);
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
    procedure Button3_Click(sender: System.Object; e: System.EventArgs);
    procedure Button4_Click(sender: System.Object; e: System.EventArgs);
    procedure Button5_Click(sender: System.Object; e: System.EventArgs);
    procedure Button6_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

uses System.Drawing.Text, SysUtils;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
var
  resources: System.Resources.ResourceManager;
begin
  resources := System.Resources.ResourceManager.Create(TypeOf(TWinForm));
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.Button2 := System.Windows.Forms.Button.Create;
  Self.Button3 := System.Windows.Forms.Button.Create;
  Self.Button4 := System.Windows.Forms.Button.Create;
  Self.Button5 := System.Windows.Forms.Button.Create;
  Self.Button6 := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(16, 16);
  Self.Button1.Name := 'Button1';
  Self.Button1.TabIndex := 0;
  Self.Button1.Text := 'Draw Text';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // Button2
  // 
  Self.Button2.Location := System.Drawing.Point.Create(112, 16);
  Self.Button2.Name := 'Button2';
  Self.Button2.TabIndex := 1;
  Self.Button2.Text := 'Fit Text';
  Include(Self.Button2.Click, Self.Button2_Click);
  // 
  // Button3
  // 
  Self.Button3.Location := System.Drawing.Point.Create(208, 16);
  Self.Button3.Name := 'Button3';
  Self.Button3.TabIndex := 2;
  Self.Button3.Text := 'Format Text';
  Include(Self.Button3.Click, Self.Button3_Click);
  // 
  // Button4
  // 
  Self.Button4.Location := System.Drawing.Point.Create(304, 16);
  Self.Button4.Name := 'Button4';
  Self.Button4.TabIndex := 3;
  Self.Button4.Text := 'Text Size';
  Include(Self.Button4.Click, Self.Button4_Click);
  // 
  // Button5
  // 
  Self.Button5.Location := System.Drawing.Point.Create(400, 16);
  Self.Button5.Name := 'Button5';
  Self.Button5.TabIndex := 4;
  Self.Button5.Text := 'Measure';
  Include(Self.Button5.Click, Self.Button5_Click);
  // 
  // Button6
  // 
  Self.Button6.Location := System.Drawing.Point.Create(496, 16);
  Self.Button6.Name := 'Button6';
  Self.Button6.TabIndex := 5;
  Self.Button6.Text := 'Unicode';
  Include(Self.Button6.Click, Self.Button6_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.BackgroundImage := (System.Drawing.Image(resources.GetObject('$this.B' +
    'ackgroundImage')));
  Self.ClientSize := System.Drawing.Size.Create(696, 582);
  Self.Controls.Add(Self.Button6);
  Self.Controls.Add(Self.Button5);
  Self.Controls.Add(Self.Button4);
  Self.Controls.Add(Self.Button3);
  Self.Controls.Add(Self.Button2);
  Self.Controls.Add(Self.Button1);
  Self.Name := 'TWinForm';
  Self.Text := 'WinForm';
  Include(Self.Paint, Self.TWinForm_Paint);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

// GDI+ has full Unicode support. This means that it is possible to render
// text in any language. For instance, the following code draws a string in
// Japanese (you must have the Japanese language pack installed).
procedure TWinForm.Button6_Click(sender: System.Object; e: System.EventArgs);
var
  g: Graphics;
  japaneseFont: System.Drawing.Font;
  japaneseText: string;
begin
  g:= CreateGraphics;
  g.TextRenderingHint:= TextRenderingHint.AntiAlias;

  try
    japaneseFont:= System.Drawing.Font.Create('MS Mincho', 32);

    japaneseText:= WideChar(31169) + WideChar(12398) + char(21517) + char(21069) + char(12399)
      + char(12463) + char(12522) + char(12473) + char(12391) + char(12377) + char(12290);

    g.DrawString(japaneseText, japaneseFont, SolidBrush.Create(Color.Blue), 20, 40);
  except
    on E: System.Exception do
    begin
      MessageBox.Show('You need to install the Japanese language pack to run this sample');
      Application.Exit;
    end;
  end;
end;

// MeasureString can also be used to determine how many lines and characters
// will be rendered. For instance, we can determine how many lines and
// characters will be rendered in the previous flowed text example.
procedure TWinForm.Button5_Click(sender: System.Object; e: System.EventArgs);
var
  g: Graphics;
  textFont: System.Drawing.Font;
  lines, characters: Integer;
  flowedText, whatRenderedText: string;
  rectangle: RectangleF;
begin
  g:= CreateGraphics;
  g.TextRenderingHint:= TextRenderingHint.AntiAlias;

  textFont:= System.Drawing.Font.Create('Lucida Sans Unicode', 12);
  rectangle:= RectangleF.Create(400, 120, 250, 350);

  flowedText:= 'Simplicity and power: Windows Forms is a programming model for'#10
    + 'developing Windows applications that combines the simplicity of the Delphi''s'#10
    + 'VCL.NET programming model with the power and flexibility of the common'#10
    + 'language runtime.'#10
    + 'Lower total cost of ownership: Windows Forms takes advantage of the versioning and'#10
    + 'deployment features of the common language runtime to offer reduced deployment'#10
    + 'costs and higher application robustness over time. This significantly lowers the'#10
    + 'maintenance costs (TCO) for applications'#10
    + 'written in Windows Forms.'#10
    + 'Architecture for controls: Windows Forms offers an architecture for'#10
    + 'controls and control containers that is based on concrete implementation of the'#10
    + 'control and container classes. This significantly reduces'#10
    + 'control-container interoperability issues.';

  g.FillRectangle(SolidBrush.Create(Color.Gainsboro), rectangle);
  g.MeasureString(flowedText, textFont, rectangle.Size, StringFormat.Create, characters, lines);

  whatRenderedText:= 'We printed ' + IntToStr(characters) + ' characters and ' + IntToStr(lines) + ' lines';

  g.DrawString(flowedText, textFont, SolidBrush.Create(Color.Blue), rectangle);
  g.DrawString(whatRenderedText, Font, SolidBrush.Create(Color.Black), 450, 480);
end;

// If you want to find out how long a string will be when it is drawn, you can use MeasureString.
// For instance, to center a string on a form, use the following code.
procedure TWinForm.Button4_Click(sender: System.Object; e: System.EventArgs);
var
  g: Graphics;
  textFont: System.Drawing.Font;
  textToDraw: string;
  stringSize: SizeF;
  windowCenter, startPos: Single;
begin
  g:= CreateGraphics;
  g.TextRenderingHint:= TextRenderingHint.AntiAlias;

  textToDraw:= 'Hello Symetrical World';
  textFont:= System.Drawing.Font.Create('Lucida Sans Unicode', 8);

  windowCenter:= DisplayRectangle.Width/2;
  stringSize:= g.MeasureString(textToDraw, textFont);
  startPos:=windowCenter-(stringSize.Width/2);

  g.DrawString(textToDraw, textFont, SolidBrush.Create(Color.Blue), startPos, 480);
end;

// You can control how the text is drawn by using the StringFormat object.
// For instance, the following code allows you to draw text that is centered in a particular area.
procedure TWinForm.Button3_Click(sender: System.Object; e: System.EventArgs);
var
  g: Graphics;
  textFont: System.Drawing.Font;
  rectangle: RectangleF;
  format: StringFormat;
  flowedText: string;
begin
  g:= CreateGraphics;
  g.TextRenderingHint:= TextRenderingHint.AntiAlias;

  textFont:= System.Drawing.Font.Create('Lucida Sans Unicode', 8);
  rectangle:= RectangleF.Create(400, 120, 250, 350);

  g.FillRectangle(SolidBrush.Create(Color.Gainsboro), rectangle);

  format:= StringFormat.Create;
  format.Alignment:= StringAlignment.Center;

  flowedText:= 'Simplicity and power: Windows Forms is a programming model for'#10
    + 'developing Windows applications that combines the simplicity of the Delphi''s'#10
    + 'VCL.NET programming model with the power and flexibility of the common'#10
    + 'language runtime.'#10
    + 'Lower total cost of ownership: Windows Forms takes advantage of the versioning and'#10
    + 'deployment features of the common language runtime to offer reduced deployment'#10
    + 'costs and higher application robustness over time. This significantly lowers the'#10
    + 'maintenance costs (TCO) for applications'#10
    + 'written in Windows Forms.'#10
    + 'Architecture for controls: Windows Forms offers an architecture for'#10
    + 'controls and control containers that is based on concrete implementation of the'#10
    + 'control and container classes. This significantly reduces'#10
    + 'control-container interoperability issues.';

  g.DrawString(flowedText, textFont, SolidBrush.Create(Color.Blue), rectangle, format);
end;

// If you supply DrawString with a Rectangle, the text will wrap to fit in the rectangle.
procedure TWinForm.Button2_Click(sender: System.Object; e: System.EventArgs);
var
  g: Graphics;
  textFont: System.Drawing.Font;
  rectangle: RectangleF;
  flowedText: string;
begin
  g:= CreateGraphics;
  g.TextRenderingHint:= TextRenderingHint.AntiAlias;

  textFont:= System.Drawing.Font.Create('Lucida Sans Unicode', 12);
  rectangle:= RectangleF.Create(120, 120, 250, 350);

  // Uncomment the line below to have a opaque rectangle.
  //g.FillRectangle(TSolidBrush.Create(Color.Gainsboro), rectangle);

  flowedText:= 'Simplicity and power: Windows Forms is a programming model for'#10
    + 'developing Windows applications that combines the simplicity of the Delphi''s'#10
    + 'VCL.NET programming model with the power and flexibility of the common'#10
    + 'language runtime.'#10
    + 'Lower total cost of ownership: Windows Forms takes advantage of the versioning and'#10
    + 'deployment features of the common language runtime to offer reduced deployment'#10
    + 'costs and higher application robustness over time. This significantly lowers the'#10
    + 'maintenance costs (TCO) for applications'#10
    + 'written in Windows Forms.'#10
    + 'Architecture for controls: Windows Forms offers an architecture for'#10
    + 'controls and control containers that is based on concrete implementation of the'#10
    + 'control and container classes. This significantly reduces'#10
    + 'control-container interoperability issues.';

  g.DrawString(flowedText, textFont, SolidBrush.Create(Color.Blue), rectangle);
end;

// Because DrawString takes a brush, it is possible to render text using any brush.
// This includes a texture brush. For instance, the following code renders the text
// with a marbled effect and a background shadow.
procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
var
  g: Graphics;
  titleBrush, backgroundBrush: TextureBrush;
  titleShadowBrush: SolidBrush;
  titleFont: System.Drawing.Font;
  titleText: string;
begin
  g:= CreateGraphics;

  // Create new brushes...
  titleBrush:= TextureBrush.Create(Bitmap.Create('WaterColor.jpg'));
  backgroundBrush:= TextureBrush.Create(Bitmap.Create('Greenstone.bmp'));
  titleShadowBrush:= SolidBrush.Create(Color.FromArgb(70, Color.Black));

  titleFont:= System.Drawing.Font.Create('Lucida Sans Unicode', 60);
  titleText:= 'Graphics Samples';

  g.TextRenderingHint:= TextRenderingHint.AntiAlias;
  g.FillRectangle(backgroundBrush, ClientRectangle);

  // White wash the canvas.
  g.FillRectangle(SolidBrush.Create(Color.FromArgb(180, Color.White)), ClientRectangle);

  // Draw shadow text first.
  g.DrawString(titleText, titleFont, titleShadowBrush, 15, 15);
  // Now draw real text.
  g.DrawString(titleText, titleFont, titleBrush, 10, 10);
end;

(*
// Because DrawString takes a brush, it is possible to render text using any brush.
// This includes a texture brush. For instance, the following code renders the text
// with a marbled effect and a background shadow.
procedure TWinForm.Button1Click(sender: System.Object; e: System.EventArgs);
end;

// If you supply DrawString with a Rectangle, the text will wrap to fit in the rectangle.
procedure TWinForm.Button2Click(Sender: TObject; Args: EventArgs);

end;


procedure TWinForm.Button3Click(Sender: TObject; Args: EventArgs);

end;

procedure TWinForm.Button4Click(Sender: TObject; Args: EventArgs);

end;

procedure TWinForm.Button5Click(Sender: TObject; Args: EventArgs);

end;

procedure TWinForm.Button6Click(Sender: TObject; Args: EventArgs);
end;
*)
// The Graphics object's DrawString methods render the text to the drawing surface.
// You pass the font and color to be used to the DrawString method.
// For instance, the following code displays the text "Hello World"
// by using the form's font and a black brush.
procedure TWinForm.TWinForm_Paint(sender: System.Object; e: System.Windows.Forms.PaintEventArgs);
var
  g: Graphics;
begin
  g:= e.Graphics;
  e.Graphics.FillRectangle(SolidBrush.Create(Color.White), ClientRectangle);
  g.DrawString('Hello World', Font, SolidBrush.Create(Color.Black), 100,100);
end;

end.
